/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.yi.etl;

import com.ptteng.yi.nucleus.model.Center;
import com.ptteng.yi.nucleus.model.Coach;
import com.ptteng.yi.nucleus.model.FreezeUser;
import com.ptteng.yi.nucleus.model.Students;
import com.ptteng.yi.nucleus.service.CenterService;
import com.ptteng.yi.nucleus.service.CoachService;
import com.ptteng.yi.nucleus.service.FreezeUserService;
import com.ptteng.yi.nucleus.service.StudentsService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;

public class UnfreezeEtl {
    private static final int TASK_LEN = 200;
    private static final long SLEEP_MILLISECOND = 86400000L;
    private static final Log log = LogFactory.getLog(UnfreezeEtl.class);
    private CenterService centerService;
    private CoachService coachService;
    private StudentsService studentsService;
    private FreezeUserService freezeUserService;
    private Long interval = 2000L;

    public void process() throws InterruptedException {
        while (true) {
            try {
                while (true) {
                    Long currentTime = System.currentTimeMillis();
                    log.info((Object)(" currentTime =============" + currentTime));
                    HashMap<String, Object> conditions = new HashMap<String, Object>();
                    conditions.put("status", 0);
                    conditions.put("thaw_time & <=", currentTime);
                    conditions.put("@query", "id ");
                    conditions.put("@table", "freeze_user");
                    List ids = this.freezeUserService.getIdsByDynamicCondition(FreezeUser.class, conditions, Integer.valueOf(0), Integer.valueOf(200));
                    log.info((Object)("unfreeze ids is: " + ids));
                    if (CollectionUtils.isEmpty((Collection)ids)) {
                        log.info((Object)("unfreeze-etl don`t get any id ,sleep " + this.interval + " ms "));
                        Thread.sleep(this.interval);
                        continue;
                    }
                    log.info((Object)("unfreeze-etl get accountIds :" + ids.size()));
                    List freezeUsers = this.freezeUserService.getObjectsByIds(ids);
                    for (FreezeUser freezeUser : freezeUsers) {
                        Integer type = freezeUser.getType();
                        switch (type) {
                            case 0: {
                                Center center = this.centerService.getObjectById(freezeUser.getUid());
                                center.setStatus(Center.STATUS_UNFREEZE);
                                this.centerService.update(center);
                                break;
                            }
                            case 1: {
                                Coach coach = this.coachService.getObjectById(freezeUser.getUid());
                                coach.setStatus(Coach.STATUS_ON.intValue());
                                this.coachService.update(coach);
                                break;
                            }
                            case 2: {
                                Students students = this.studentsService.getObjectById(freezeUser.getUid());
                                students.setStatus(Students.STATUS_ON.intValue());
                                this.studentsService.update(students);
                                break;
                            }
                        }
                        freezeUser.setStatus(1);
                        this.freezeUserService.update(freezeUser);
                    }
                    Thread.sleep(this.interval);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                Thread.sleep(this.interval);
                log.error((Object)("process check expire-user error ,sleep " + t.getMessage()));
                continue;
            }
            break;
        }
    }

    public CenterService getCenterService() {
        return this.centerService;
    }

    public void setCenterService(CenterService centerService) {
        this.centerService = centerService;
    }

    public CoachService getCoachService() {
        return this.coachService;
    }

    public void setCoachService(CoachService coachService) {
        this.coachService = coachService;
    }

    public StudentsService getStudentsService() {
        return this.studentsService;
    }

    public void setStudentsService(StudentsService studentsService) {
        this.studentsService = studentsService;
    }

    public FreezeUserService getFreezeUserService() {
        return this.freezeUserService;
    }

    public void setFreezeUserService(FreezeUserService freezeUserService) {
        this.freezeUserService = freezeUserService;
    }

    public Long getInterval() {
        return this.interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }
}

